#include <stdio.h>
#include <string.h>

#include "vfs.h"
#include "blockdev.h"

struct fsys_entry {
	char *name;
	int (*mount_func) (void);
	int (*read_func) (char *buf, int len);
	int (*dir_func) (char *dirname);
	int (*close_func) (void);
} static const fsys_table[] = {
	{ "ext2", ext2fs_mount, ext2fs_read, ext2fs_dir, NULL },
	{ "iso9660", iso9660_mount, iso9660_read, iso9660_dir, NULL },
	{ "nullfs", nullfs_mount, nullfs_read, nullfs_dir, NULL },
};

static const size_t fsys_table_length = sizeof(fsys_table) / sizeof(fsys_table[0]);

const struct fsys_entry *fsys = NULL;
int filemax;
int filepos;

int mount_fs(char *fs_name)
{
	for (size_t i = 0; i < fsys_table_length; i++) {
		if ((!fs_name || !strcmp(fsys_table[i].name, fs_name)) && fsys_table[i].mount_func()) {
			fsys = &fsys_table[i];
			return 1;
		}
	}

	if (fs_name)
		fprintf(stderr, "mount_fs: Faild to mount filesystem: %s.\n", fs_name);
	else
		fprintf(stderr, "mount_fs: No matching filesystem found.\n");
	return 0;
}




int file_open(const char *filename)
{
	if (!fsys) {
		fprintf(stderr, "file_open: no open filesystem.\n");
		return 0;
	}
	char *path = strdup(filename);
	if (!fsys->dir_func(path)) {
		fprintf(stderr, "file_open: file not found '%s'.\n", filename);
		return 0;
	}
	filepos = 0;
	return 1;
}

int file_read(void *buf, unsigned long len)
{
	if (filepos < 0 || filepos > filemax)
		filepos = filemax;

	if (len < 0 || len > filemax - filepos)
		len = filemax - filepos;
	return fsys->read_func(buf, len);
}

unsigned long file_seek(unsigned long offset)
{
	if (offset <= filemax)
		filepos = offset;
	else
		filepos = filemax;
	return filepos;
}

unsigned long file_size(void)
{
	return filemax;
}

void file_close(void)
{
	// In contrast to filo the device is not closed here
	// devclose();
}

