#ifndef BLOCKDEV_H
#define BLOCKDEV_H

/** devopen
 * @param name    Filename to be used as blockdevice
 * @param reopen  Unused, set NULL
 * @return        1 on success, 0 on failure !CAUTION
 */
int devopen(const char *name, int *reopen);

/** devclose
 */
void devclose(void);

/** devread
 * @param sector       512 byte sector of the block device
 * @param byte_offset  Offset in the block
 * @param byte_len     Buffer length
 * @param buf          Buffer
 * @return             1 on sucess, 0 on failure !CAUTION
 */
int devread(unsigned long sector, unsigned long byte_offset,
	unsigned long byte_len, void *buf);

/** dev_set_partition
 * Set partition offset and size. if start + size > blockdevice, do nothing
 * @param start
 * @param size
 */
void dev_set_partition(unsigned long start, unsigned long size);

/** dev_get_partition
 * @param *start  will be filled with the partition offset
 * @param *size   will be filled with the partition length
 */
void dev_get_partition(unsigned long *start, unsigned long *size);

#endif /* BLOCKDEV_H */
