#ifndef VFS_H
#define VFS_H

/** mount_fs
 * @param fs_name  Name of filesystem or NULL for auto selection
 * @return 1 on success, 0 on failure
 */
int mount_fs(char *fs_name);

/** file_open
 * @param filename
 * @return 1 on success, 0 on failure
 */
int file_open(const char *filename);

/** file_read
 * @param buf
 * @param len  Size of buffer / bytes to read
 * @return     Number of bytes read
 */
int file_read(void *buf, unsigned long len);

unsigned long file_seek(unsigned long offset);
/**file_size
 * @return  Filesize in bytes
 */
unsigned long file_size(void);

void file_close(void);

int nullfs_mount(void);
int nullfs_read(char*, int);
int nullfs_dir(char*);

int ext2fs_mount(void);
int ext2fs_read(char *buf, int len);
int ext2fs_dir(char *path);
int iso9660_mount(void);
int iso9660_read(char *buf, int len);
int iso9660_dir(char *path);

#endif /* VFS_H */
