with Interfaces;
with Interfaces.C;

use Interfaces.C;

package FILO.FS is

   type File_Type is (Dir, Regular, Link);

   type File_Length is range 0 .. int'Last; -- Should be higher, fix FILO first
   subtype File_Offset is File_Length;

private
   function Part_Len return Partition_Length;

   function File_Max return File_Length;
   procedure Set_File_Max (Len : File_Length);

   function File_Pos return File_Offset;
   procedure Set_File_Pos (Off : File_Offset);

end FILO.FS;
