package body FILO.FS is

   C_Part_Length : unsigned_long
   with
      Import         => True,
      Convention     => C,
      External_Name  => "part_length";

   C_File_Max : int
   with
      Import         => True,
      Convention     => C,
      External_Name  => "filemax";

   C_File_Pos : int
   with
      Import         => True,
      Convention     => C,
      External_Name  => "filepos";

   pragma Warnings
     (GNAT, Off, "condition can only be False*",
      Reason => "Depends on `unsigned long` size.");
   pragma Warnings
     (GNAT, Off, "condition is always True",
      Reason => "Depends on `unsigned long` size.");
   function Part_Len return Partition_Length
   is
     (if Unsigned_64 (C_Part_Length) <= Unsigned_64 (Partition_Length'Last) / 512
      then Partition_Length (C_Part_Length) * 512
      else Partition_Length'Last);
   pragma Warnings (GNAT, On, "condition can only be False*");
   pragma Warnings (GNAT, On, "condition is always True");

   function File_Max return File_Length is
   begin
      if C_File_Max < 0 then
         return 0;
      end if;

      return File_Length (C_File_Max);
   end File_Max;

   procedure Set_File_Max (Len : File_Length) is
   begin
      C_File_Max := int (Len);
   end Set_File_Max;

   function File_Pos return File_Offset is
   begin
      if C_File_Pos < 0 then
         return 0;
      end if;

      return File_Offset (C_File_Pos);
   end File_Pos;

   procedure Set_File_Pos (Off : File_Offset) is
   begin
      C_File_Pos := int (Off);
   end Set_File_Pos;

end FILO.FS;
