with Interfaces.C;
with Interfaces.C.Strings;
with System;

package FILO.FS.NullFS is
   -- noop init
   function C_Mount return Interfaces.C.int
   with
      Export,
      Convention => C,
      External_Name => "nullfs_mount";

   function C_Read -- read from blockdev
      (buf : System.Address; -- char*
       len : Interfaces.C.int)
   return Interfaces.C.int
   with
      Export,
      Convention => C,
      External_Name => "nullfs_read";

   function C_Dir -- noop like open
      (Path : System.Address) -- char*
   return Interfaces.C.int
   with
      Export,
      Convention => C,
      External_Name => "nullfs_dir";

end FILO.FS.NullFS;
