with FILO.Blockdev;

package body FILO.FS.NullFS is

   function To_Int (Success : Boolean) return Interfaces.C.int is
      (if Success then 1 else 0);

   function C_Mount return Interfaces.C.int is
   begin
      return To_Int (True);
   end C_Mount;

   function C_Read 
      (buf : System.Address;
       len : Interfaces.C.int)
   return Interfaces.C.int
      with SPARK_Mode => Off
   is
      Buffer : Buffer_Type (0 .. Integer(len) - 1) with Address => buf;
      Offset : constant Blockdev_Offset := Blockdev_Offset(File_Pos);
      Success : Boolean;
   begin
      FILO.Blockdev.Read (Buffer, Offset, Success);
      return To_Int (Success); 
   end C_Read;


   function C_Dir
      (Path : System.Address)
   return Interfaces.C.int
      with SPARK_Mode => Off
   is
      First_Byte : Unsigned_8 with Address => Path;
   begin
      if First_Byte = 0 then
         return To_Int (True);
      end if;
      return To_Int (False);
   end C_Dir;

end FILO.FS.NullFS;
